def nearest_ge(h, indices):
    n = len(h)
    res = [-1] * n
    st = []
    for i in indices:
        while st and h[st[-1]] < h[i]:   # dozvoljeno >=
            st.pop()
        res[i] = st[-1] if st else -1
        st.append(i)
    return res


def solve():
    n = int(input())
    x = list(map(int, input().split()))
    h = list(map(int, input().split()))

    # sort by x, keep heights attached
    pairs = sorted(zip(x, h))   # sortira po x automatski
    x = [p[0] for p in pairs]
    h = [p[1] for p in pairs]

    L = nearest_ge(h, range(n))              # levo
    R = nearest_ge(h, range(n - 1, -1, -1))  # desno

    for i in range(n):
        best = None

        if L[i] != -1:
            dx = x[i] - x[L[i]]      # sad je x rastuci, abs nije potreban
            dh = h[L[i]] - h[i]
            best = dx - dh

        if R[i] != -1:
            dx = x[R[i]] - x[i]
            dh = h[R[i]] - h[i]
            val = dx - dh
            best = val if best is None else min(best, val)

        print(best if best is not None else -1)


solve()